<?
// Load news items in from external file
include("news.php");

// Un-escape any special characters in our search criteria string
$doCriteria = stripslashes($doCriteria);

// Initialise our variable to hold search results
$searchResults = "";

// If we're performing a simple search...
if ($doMethod == "Simple") {
    // Call the simple search function and store return value
    $searchResults = SimpleSearch();
} else {
    // Call the advances search function and store return value
    $searchResults = AdvancedSearch();
}

// Output search header
print "&searchResults=";
print urlencode("Method: $doMethod\nCriteria: $doCriteria\nCase: $doCase\n\n");

// Output search results
print urlencode($searchResults) . "&";


// Function to perform a simple string search
function SimpleSearch() {
    // Global variables
    global $newsItems;
    global $doCriteria;
    global $doCase;

    // For each news item in array...
    for($count = 0; $count < count($newsItems); $count++) {
        
        // Loop through each element of news item...
        foreach($newsItems[$count] as $value) {
            
            // If we're performing a case sensitive match...
            if ($doCase == "true") {
                
                // Use case sensitive function to check for match
                // If match found...
                if (strstr($value, $doCriteria)) {
                    
                    // Store news item details for output
                    $searchResults .= '<font color="#003366"><b>';
                    $searchResults .= $newsItems[$count]['Title'];
                    $searchResults .= '</b></font><br>';
                    $searchResults .= $newsItems[$count]['Body'];
                    $searchResults .= '<br><br>';
                    
                    // Move on to next news item
                    break;
                }
            } else {
                
                // Use case insensitive function to check for match
                // If match found...
                if (stristr($value, $doCriteria)) {

                    // Store news item details for output
                    $searchResults .= '<font color="#003366"><b>';
                    $searchResults .= $newsItems[$count]['Title'];
                    $searchResults .= '</b></font><br>';
                    $searchResults .= $newsItems[$count]['Body'];
                    $searchResults .= '<br><br>';
                    // Move on to next news item
                    break;
                }   
            }
        }
    }

    // If we didn't find a single match...
    if (strlen($searchResults) == 0) {
        // Set "no match" message
        $searchResults = "No match found";
    }

    // Return search results...
    return $searchResults;
}

// Function to perform a regular expression search
function AdvancedSearch() {
    // Global variables
    global $newsItems;
    global $doCriteria;
    global $doCase;

    // For each news item in array...
    for($count = 0; $count < count($newsItems); $count++) {
        
        // Loop through each element of news item...
        foreach($newsItems[$count] as $value) {
            
            // If we're performing a case sensitive match...
            if ($doCase == "true") {
                
                // Use case sensitive function to check for match
                // If match found...
                if (ereg($doCriteria, $value)) {
                    
                    // Store news item details for output
                    $searchResults .= '<font color="#003366"><b>';
                    $searchResults .= $newsItems[$count]['Title'];
                    $searchResults .= '</b></font><br>';
                    $searchResults .= $newsItems[$count]['Body'];
                    $searchResults .= '<br><br>';
                    
                    // Move on to next news item
                    break;
                }
            } else {
                // Use case insensitive function to check for match
                // If match found...
                if (eregi($doCriteria, $value)) {

                    // Store news item details for output
                    $searchResults .= '<font color="#003366"><b>';
                    $searchResults .= $newsItems[$count]['Title'];
                    $searchResults .= '</b></font><br>';
                    $searchResults .= $newsItems[$count]['Body'];
                    $searchResults .= '<br><br>';

                    // Move on to next news item
                    break;
                }   
            }
        }
    }

    // If we didn't find a single match...
    if (strlen($searchResults) == 0) {
        // Set "no match" message
        $searchResults = "No match found";
    }

    // Return search results...
    return $searchResults;
}
?>